within ;
model CentrifugalClutchTestBench

  Modelica.Mechanics.Rotational.Components.Damper damper(d=0.001)
    annotation (Placement(transformation(extent={{62,24},{82,44}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{72,-12},{92,8}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-40,24},{-20,44}})));
  CentrifugalClutch centrifugalClutch
    annotation (Placement(transformation(extent={{-6,20},{14,40}})));
  Modelica.Blocks.Sources.Ramp ramp(
    offset=0,
    height=1.5,
    duration=5)
    annotation (Placement(transformation(extent={{-80,22},{-60,42}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=0.1)
    annotation (Placement(transformation(extent={{26,24},{46,44}})));
equation
  connect(torque.flange, centrifugalClutch.flange_a) annotation (Line(
      points={{-20,34},{-9.8,34},{-9.8,34.6},{-3.6,34.6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper.flange_b, fixed.flange) annotation (Line(
      points={{82,34},{82,-2}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(ramp.y, torque.tau) annotation (Line(
      points={{-59,32},{-50,32},{-50,34},{-42,34}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(centrifugalClutch.flange_b, inertia.flange_a) annotation (Line(
      points={{11,34.6},{20.5,34.6},{20.5,34},{26,34}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, damper.flange_a) annotation (Line(
      points={{46,34},{62,34}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end CentrifugalClutchTestBench;
